\name{read_stan_csv}
\alias{read_stan_csv}
\title{Read CSV files of samples generated by (R)Stan into a \code{stanfit} object}
\description{Create a \code{stanfit} object from the saved CSV files that are
  created by Stan or RStan and that include the samples drawn from the
  distribution of interest to facilitate analysis of samples using RStan.  
} 

\usage{
read_stan_csv(csvfiles, col_major = TRUE)
}

\arguments{
  \item{csvfiles}{A character vector providing CSV file names}
  \item{col_major}{The order for array parameters; default to \code{TRUE}}
}

\details{
  Stan and RStan could save the samples to CSV files.  This function
  reads the samples and using the comments (beginning with \code{"#"})
  to create a \code{stanfit} object. The model name is derived from 
  the first CSV file. 

  \code{col_major} specifies how array parameters are ordered in each row of
  the CSV files.  For example, parameter \code{"a[2,2]"} would be ordered as
  \code{"a[1,1], a[2,1], a[1,2], a[2,2]"} if col_major is \code{TRUE}. 
} 

\value{
  A \code{stanfit} object (with invalid \code{stanmodel} slot). This \code{stanfit}
  object cannot be used to re-run the sampler. 
} 


\seealso{
  \code{\linkS4class{stanfit}} 
} 
\examples{
csvfiles <- dir(system.file('misc', package = 'rstan'),
                pattern = 'rstan_doc_ex_[0-9].csv', full.names = TRUE)
fit <- read_stan_csv(csvfiles)
}
