% Generated by roxygen2 (4.0.2): do not edit by hand
\name{insert_back.rdeque}
\alias{insert_back.rdeque}
\title{Insert an element into the back of an rdeque}
\usage{
\method{insert_back}{rdeque}(x, e, ...)
}
\arguments{
\item{x}{rdeque to insert onto.}

\item{e}{element to insert.}

\item{...}{additional arguments to be passed to or from methods (ignored).}
}
\value{
modified version of the rdeque.
}
\description{
Returns a version of the deque with the new element in the back position.
}
\details{
Runs in \eqn{O(1)} time worst-case. Does not modify the original.
}
\examples{
d <- rdeque()
d <- insert_back(d, "a")
d <- insert_back(d, "b")
print(d)

d2 <- insert_back(d, "c")
print(d2)
print(d)
}
\references{
Okasaki, Chris. Purely Functional Data Structures. Cambridge University Press, 1999.
}

