% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/items-funs.R
\name{items_functions}
\alias{items_functions}
\alias{items_length}
\alias{items_length.STACItem}
\alias{items_length.STACItemCollection}
\alias{items_matched}
\alias{items_matched.STACItem}
\alias{items_matched.STACItemCollection}
\alias{items_fetch}
\alias{items_fetch.STACItem}
\alias{items_fetch.STACItemCollection}
\alias{items_next}
\alias{items_next.STACItem}
\alias{items_next.STACItemCollection}
\alias{items_datetime}
\alias{items_datetime.STACItem}
\alias{items_datetime.STACItemCollection}
\alias{items_bbox}
\alias{items_bbox.STACItem}
\alias{items_bbox.STACItemCollection}
\alias{items_assets}
\alias{items_assets.STACItem}
\alias{items_assets.STACItemCollection}
\alias{items_filter}
\alias{items_reap}
\alias{items_fields}
\alias{items_fields.STACItemCollection}
\alias{items_fields.STACItem}
\alias{items_group}
\alias{items_sign}
\alias{items_sign.STACItemCollection}
\alias{items_sign.STACItem}
\title{STACItemCollection functions}
\usage{
items_length(items)

\method{items_length}{STACItem}(items)

\method{items_length}{STACItemCollection}(items)

items_matched(items, ...)

\method{items_matched}{STACItem}(items, ...)

\method{items_matched}{STACItemCollection}(items, ..., matched_field = NULL)

items_fetch(items, ...)

\method{items_fetch}{STACItem}(items, ...)

\method{items_fetch}{STACItemCollection}(items, ..., progress = TRUE, matched_field = NULL)

items_next(items, ...)

\method{items_next}{STACItem}(items, ...)

\method{items_next}{STACItemCollection}(items, ...)

items_datetime(items)

\method{items_datetime}{STACItem}(items)

\method{items_datetime}{STACItemCollection}(items)

items_bbox(items)

\method{items_bbox}{STACItem}(items)

\method{items_bbox}{STACItemCollection}(items)

items_assets(items, ...)

\method{items_assets}{STACItem}(items, ...)

\method{items_assets}{STACItemCollection}(items, ..., simplify = FALSE)

items_filter(items, ..., filter_fn = NULL)

items_reap(items, ..., field = NULL)

items_fields(items, ..., field = NULL)

\method{items_fields}{STACItemCollection}(items, ..., field = NULL)

\method{items_fields}{STACItem}(items, ..., field = NULL)

items_group(items, ..., field = NULL, index = NULL)

items_sign(items, ..., sign_fn = NULL)

\method{items_sign}{STACItemCollection}(items, ..., sign_fn = NULL)

\method{items_sign}{STACItem}(items, ..., sign_fn = NULL)
}
\arguments{
\item{items}{a \code{STACItemCollection} object representing
the result of \verb{/stac/search}, \code{/collections/{collectionId}/items}.}

\item{...}{a named way to provide field names to get the subfields values
from the \code{RSTACDocument} objects.}

\item{matched_field}{a \code{character} vector with the path
where the number of items returned in the named list is located starting from
the initial node of the list. For example, if the information is at position
\code{items$meta$found} of the object, it must be passed as the following
parameter \code{c("meta", "found")}.}

\item{progress}{a \code{logical} indicating if a progress bar must be
shown or not. Defaults to \code{TRUE}.}

\item{simplify}{a \code{logical} should return only the assets name of the
first item? if not a \code{list} with all assets name will be returned. Default
is \code{FALSE}.}

\item{filter_fn}{a \code{function} that receives an item that should
evaluate a \code{logical} value.}

\item{field}{a \code{character} with the names of the field to get the
subfields values from the \code{RSTACDocument} objects.}

\item{index}{an \code{atomic} vector with values as group index}

\item{sign_fn}{a \code{function} that receives an item as parameter
and returns an item signed.}
}
\value{
\itemize{
\item \code{items_length()}: an \code{integer} value.

\item \code{items_matched()}: returns an \code{integer} value if STAC web server does
support this extension, otherwise returns \code{NULL}.

\item \code{items_fetch()}: an \code{STACItemCollection} with all matched items.

\item \code{items_next()}: fetches a new page from STAC service.

\item \code{items_datetime()}: a \code{list} of all items' datetime.

\item \code{items_bbox()}: returns a \code{list} with all items' bounding boxes.

\item \code{item_assets()}: if simplify is \code{TRUE}, returns a \code{character}
value with all assets names of the first item. Otherwise, returns a
\code{list} with assets name for each item.

\item \code{items_filter()}: a \code{STACItemCollection} object.

\item \code{items_reap()}: a \code{vector} if the supplied field is atomic,
otherwise or a \code{list}.

\item \code{items_fields()}: a \code{character} vector.

\item \code{items_group()}: a \code{list} of \code{STACItemCollection} objects.

\item \code{items_sign()}: a \code{STACItemCollection} object with signed assets url
}

A \code{character} with the subfields of the \code{feature} field.
}
\description{
These functions provide support to work with
\code{STACItemCollection} and \code{STACItem} objects.

\itemize{
\item \code{items_length()}: shows how many items there are in
the \code{STACItemCollection} object.

\item \code{items_matched()}: shows how many items matched the
search criteria. It supports \code{search:metadata} (v0.8.0),
\code{context} (v0.9.0), and \code{numberMatched} (OGC WFS3 core spec).

\item \code{items_fetch()}: request all STAC Items through
pagination.

\item \code{items_next()}: fetches a new page from STAC service.

\item \code{items_datetime()}: retrieves a the \code{datetime}
field in \code{properties} from \code{STACItemCollection} and
\code{STACItem} objects.

\item \code{items_bbox()}: retrieves a the \code{bbox}
field of a \code{STACItemCollection} or an \code{STACItem} object.

\item \code{item_assets()}: returns the assets name from
\code{STACItemCollection} and \code{STACItem} objects.

\item \code{items_filter()}: selects only items that match some
criteria.

\item \code{items_reap()}: extract key values by traversing all items
in an \code{STACItemCollection} object.

\item \code{items_fields()}: lists field names inside an item.

\item \code{items_group()}: organizes items as elements of a list using
some criteria.

\item \code{items_sign()}: allow access assets by preparing its url.
}

This function returns the subfields of the \code{feature}
field of a \code{STACItemCollection} object.
}
\details{
Ellipsis argument (\code{...}) appears in different items function and
has distinct purposes:
\itemize{
\item \code{items_matched()} and \code{items_assets()}: ellipsis is not used.

\item \code{items_fetch()} and \code{items_next()}: ellipsis is used to pass
additional \code{httr} options to \link[httr:GET]{GET} or \link[httr:POST]{POST}
methods, such as \link[httr:add_headers]{add_headers} or
\link[httr:set_cookies]{set_cookies}.

\item \code{items_filter()}: ellipsis is used to pass logical
expressions using keys in \code{properties} field as filter criteria.

\item \code{items_reap()}, \code{items_fields()}, and \code{items_group()}: ellipsis can
be used to provide fields names to get the subfields values from
the \code{STACItemCollection} objects.

\item \code{items_sign()}: in a near future, ellipsis will be used to append
key value pairs to url query string of an asset.
}

\code{items_sign()} has \code{sign_fn} parameter that must be a function that
receives as argument an item and returns an signed item. \code{rstac} provides
\code{sign_bdc()} and \code{sign_planetary_computer()} functions to access Brazil
Data Cube products and Microsoft Planetary Computer catalogs, respectively.
}
\examples{

\dontrun{

x <- stac("https://brazildatacube.dpi.inpe.br/stac") \%>\%
    stac_search(collections = "CB4_64_16D_STK-1") \%>\%
    stac_search(limit = 500) \%>\%
    get_request()

x \%>\% items_length()
x \%>\% items_matched()
x \%>\% items_datetime()
x \%>\% items_bbox()
x \%>\% items_fetch()
}

\dontrun{

# Defining BDC token
Sys.setenv("BDC_ACCESS_KEY" = <your_bdc_access_key>)

# STACItem object
stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
    stac_search(collections = "CB4_64_16D_STK-1", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
    get_request() \%>\% items_sign(sign_fn = sign_bdc())

}

\dontrun{

# STACItemCollection object
stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
    stac_search(collections = "CB4_64_16D_STK-1", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
    get_request() \%>\% items_filter(`eo:cloud_cover` < 10)

# Example with AWS STAC
stac("https://earth-search.aws.element84.com/v0") \%>\%
    stac_search(collections = "sentinel-s2-l2a-cogs",
              bbox = c(-48.206,-14.195,-45.067,-12.272),
              datetime = "2018-06-01/2018-06-30",
              limit = 500) \%>\%
    post_request() \%>\%
    items_filter(filter_fn = function(x) {x[["eo:cloud_cover"]] < 10})
}

\dontrun{
# STACItemCollection object
stac_item <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
 get_request() \%>\% items_fetch(progress = FALSE)

stac_item \%>\% items_reap(field = c("properties", "datetime"))
}

\dontrun{
# STACItemCollection object
stac_item <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
 get_request() \%>\% items_fetch(progress = FALSE)

 stac_item \%>\% items_group(., field = c("properties", "bdc:tiles"))
}

\donttest{
# STACItemCollection object
stac_item <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1", limit = 10,
        datetime = "2017-08-01/2018-03-01") \%>\%
 get_request()

stac_item \%>\% items_fields(field = c("properties"))
}

}
