% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{users}
\alias{users}
\title{Get openSNP users.}
\usage{
users(df = FALSE, ...)
}
\arguments{
\item{df}{Return data.frame (\code{TRUE}) or not (\code{FALSE}). Default: \code{FALSE}}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
List of openSNP users, their ID numbers, and XX if available.
}
\description{
Get openSNP users.
}
\examples{
\dontrun{
# just the list
data <- users(df = FALSE)
data

# get a data.frame of the users data
data <- users(df = TRUE)
data[[1]] # users with links to genome data
data[[2]] # users without links to genome data
}
}
\seealso{
Other opensnp-fxns: \code{\link{allgensnp}},
  \code{\link{allphenotypes}}, \code{\link{annotations}},
  \code{\link{download_users}},
  \code{\link{fetch_genotypes}}, \code{\link{genotypes}},
  \code{\link{phenotypes_byid}}, \code{\link{phenotypes}}
}
\concept{opensnp-fxns}
