% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentize.R
\name{line_segmentize}
\alias{line_segmentize}
\title{Segments a LineString into \code{n} equal length LineStrings}
\usage{
line_segmentize(x, n)
}
\arguments{
\item{x}{and object of class \code{rs_LINESTRING}}

\item{n}{an integer vector determining the number of equal length LineStrings to create}
}
\value{
A vector of class \code{rs_MULTILINESTRING}
}
\description{
Given a LineString, segment it into \code{n} equal length LineStrings.
The \code{n} LineStrings are provided as a \code{MultiLineString} which can
be expanded using \code{expand_geoms()} and consequently flattened
using \code{flatten_geoms()} if desired.
}
\examples{
x <- geom_linestring(1:10, runif(10, -1, 1))

segs <- line_segmentize(x, 3)

flatten_geoms(
  expand_geoms(segs)
)
}
