% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{sc_dict}
\alias{sc_dict}
\title{Search data dictionary.}
\usage{
sc_dict(search_string, search_col = c("all", "description", "varname",
  "dev_friendly_name", "dev_category", "label"), ignore_case = TRUE,
  limit = 10, confirm = FALSE)
}
\arguments{
\item{search_string}{Character string for search. Can use regular
expression for search. Must escape special characters,
\code{. \ | ( ) [ \{ ^ $ * + ?}, with a doublebackslash
\code{\\\\}.}

\item{search_col}{Column to search. The default is to search all
columns.  Other options include: "varname",
"dev_friendly_name", "dev_category", "label".}

\item{ignore_case}{Search is case insensitive by default. Change to
\code{FALSE} to restrict search to exact case matches.}

\item{limit}{Only the first 10 dictionary items are returned by
default. Increase to return more values. Set to \code{Inf} to
return all items matched in search'}

\item{confirm}{Use to confirm status of variable name in
dictionary. Returns \code{TRUE} or \code{FALSE}.}
}
\description{
This function is used to search the College Scorecard
data dictionary.
}
\examples{
sc_dict('state')
sc_dict('^st', search_col = 'varname') # variable names starting with 'st'
sc_dict('.', limit = Inf) # return full dictionary (not recommended)
}

