% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abstract_retrieval.R
\name{abstract_retrieval}
\alias{abstract_retrieval}
\title{SCOPUS Abstract Retrieval}
\usage{
abstract_retrieval(id, identifier = c("scopus_id", "eid", "doi", "pii",
  "pubmed_id", "pui", "group_id"), http_end = NULL, ...)
}
\arguments{
\item{id}{Identifier for abstract}

\item{identifier}{Type of identifier to use}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
retrieval of an abstract from the Elsevier Abstract Retrieval API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = abstract_retrieval("S1053811915002700", identifier = "pii",
   verbose = FALSE)
   x = abstract_retrieval("S1053811915002700", identifier = "pii",
   view = "FULL",
   verbose = FALSE)
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}
