% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/object_retrieval.R
\name{object_retrieval}
\alias{object_retrieval}
\title{ScienceDirect Object Retrieval}
\usage{
object_retrieval(id, identifier = c("scopus_id", "eid", "doi", "pii",
  "pubmed_id"), ref = NULL, http_end = NULL, ...)
}
\arguments{
\item{id}{Identifier for object}

\item{identifier}{Type of identifier to use}

\item{ref}{document reference}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
retrieval of an object from the Elsevier Object Retrieval API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = object_retrieval("S1053811915002700", identifier = "pii")
   if (require(xml2) & require(httr)){
       library(httr)
       refs = httr::content(x$get_statement, "text")
       refs = read_xml(refs)
       refs = xml_nodes(refs, "choice")
       texts = xml_text(refs)
       types = xml_attr(refs, "type")
       refs = xml_attr(refs, "ref")
       df = data.frame(ref = refs, type = types, text = texts,
       stringsAsFactors = FALSE)
       df = df[ grepl("image/jpeg", df$text),,drop = FALSE ]
       df = df[ df$type \%in\% "IMAGE-HIGH-RES",,drop = FALSE ]
       r = GET(df$text[1],
               query = list(
                 "apiKey" = api_key))
       img = content(r)
       dims = dim(img)[1:2]
       mdim = max(dims)
       plot(c(0, ncol(img)), c(0, nrow(img)), type='n')
       rasterImage(img, 1, 1, ncol(img), nrow(img))
   }
 obj = object_retrieval('S1053811915002700', "pii")
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}

