% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{-.rscalaReference}
\alias{-.rscalaReference}
\alias{unaryMinus}
\title{Operator to Reconstitute an R object}
\usage{
\method{-}{rscalaReference}(rscalaReference, e2)
}
\arguments{
\item{rscalaReference}{An rscala reference of type \code{org.ddahl.rscala.RObject}.}

\item{e2}{Ignored since only the unary minus operator is supported for rscala references.}
}
\description{
This operator reconstitutes an R object that has been created by the binary minus
operator \code{\link{-.rscalaReference}} on a scala bridge.
}
\examples{
\donttest{
scala(assign.name='e')      # Implicitly defines the bridge 'e'.
e(func=e-rnorm, arg=10) * 'R.evalD1("\%-(\%-)",func,arg)'
wrappedFunction <- e - dnorm
identical((-wrappedFunction)(1.0), dnorm(1.0))
close(e)
}
 
}
\seealso{
\code{\link{-.rscalaBridge}}
}
