% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_2ggplots.R
\name{add_2flextables}
\alias{add_2flextables}
\title{Add two flextables into a document object}
\usage{
add_2flextables(mydoc, ft1, ft2, echo = FALSE, width = 3, code = "")
}
\arguments{
\item{mydoc}{A document object}

\item{ft1}{The first flextable}

\item{ft2}{The second flextable}

\item{echo}{whether or not display R code}

\item{width}{plot width in inches}

\item{code}{R code string}
}
\value{
a document object
}
\description{
Add two flextables into a document object
}
\examples{
require(rrtable)
require(officer)
require(magrittr)
title="Two Tables"
ft1=df2flextable(head(iris[1:4]))
ft2=df2flextable(tail(iris[1:4]))
doc=read_docx()
doc \%>\% add_text(title=title) \%>\%
        add_2flextables(ft1,ft2) \%>\%
        print(target=paste0(tempdir(),"/","2tables.docx"))
}
