% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{rrr.leverage}
\alias{rrr.leverage}
\title{Leverage scores and Cook's distance in reduced-rank regression
for model diagnostics}
\usage{
rrr.leverage(Y, X = NULL, nrank = 1, qr.tol = 1e-07)
}
\arguments{
\item{Y}{a matrix of response (n by q)}

\item{X}{a matrix of covariate (n by p)}

\item{nrank}{an integer specifying the desired rank}

\item{qr.tol}{tolerence to be passed to `qr'}
}
\value{
`rrr.leverage' returns a list containing a vector of leverages
 and a scalar of the degrees of freedom (sum of leverages).
`rrr.cooks' returns a list containing
  \item{residuals}{resisuals matrix}
  \item{mse}{mean squared error}
  \item{leverage}{leverage}
  \item{cookD}{Cook's distance}
  \item{df}{degrees of freedom}
}
\description{
Compute leverage scores and Cook's distance for model diagnostics
in \code{rrr} estimation.
}
\references{
Chen, K. Model diagnostics in reduced-rank estimation. \emph{Statistics and
Its interface}, 9, 469--484.
}
