/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import rreval.Message;
import rreval.RReader;
import rreval.RWriter;

public class ConnectionR {
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private RReader rReader;
    private RWriter rWriter;

    public ConnectionR(Socket socket) throws IOException {
        this.socket = socket;
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        this.rReader = new RReader(this);
        this.rWriter = new RWriter(this);
    }

    public int read(char[] buffer) throws IOException {
        return this.reader.read(buffer, 0, buffer.length);
    }

    public void write(char[] buffer) throws IOException {
        this.writer.write(buffer, 0, buffer.length);
        this.writer.flush();
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public Message readMessage() throws Exception {
        return this.rReader.readMessage();
    }

    public void writeMessage(Message m) throws Exception {
        this.rWriter.writeMessage(m);
    }
}

