% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld_weights.R
\name{ld.weights}
\alias{ld.weights}
\title{LD weights}
\usage{
ld.weights(data, input.genotype = TRUE)
}
\arguments{
\item{data}{numeric matrix.}

\item{input.genotype}{logical.}
}
\value{
A numeric vector of weights. Note that the sum of weights is not constrained to be 1. They should be scaled appropriately before computing the LD weighted GRM.
}
\description{
\code{ld.weights} computes LD weights for all markers, which is subsequently used to compute LD weighted GRM.
}
\details{
\code{data} can either be the subject by marker numeric genotype matrix (with 0, 1 or 2 coding), or the matrix of marker genotypic correlations. The default option is to input genotype matrix.
}
\examples{
# simulate genotypes of 500 individuals at 100 markers
nsnp = 100 # number of SNPs
freq = runif(nsnp, 0.05, 0.95)
nhaplo = 1000 # number of founder haplotypes
haplo.mat = sim.haplotype(freq, nhaplo)
geno.mat = t(sapply(c(1:500), function(x) 4 - haplo.mat[2*x-1,] - haplo.mat[2*x,]))

# compute unconstrained LD weights
ld.weights(geno.mat)
}
