/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.OutputStream;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.SyntaxLabels;

public class SinkQuadOutput
implements Sink<Quad> {
    private Prologue prologue = null;
    private AWriter out;
    private NodeToLabel labelPolicy = null;
    private NodeFormatter nodeFmt = new NodeFormatterNT();

    @Deprecated
    public SinkQuadOutput(OutputStream outs) {
        this(outs, null, SyntaxLabels.createNodeToLabel());
    }

    public SinkQuadOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.out = IO.wrapUTF8(outs);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    @Override
    public void send(Quad quad) {
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = quad.getGraph();
        this.nodeFmt.format(this.out, s);
        this.out.print(" ");
        this.nodeFmt.format(this.out, p);
        this.out.print(" ");
        this.nodeFmt.format(this.out, o);
        if (SinkQuadOutput.outputGraphSlot(g)) {
            this.out.print(" ");
            this.nodeFmt.format(this.out, g);
        }
        this.out.print(" .\n");
    }

    private static boolean outputGraphSlot(Node g) {
        return g != null && g != Quad.tripleInQuad && !Quad.isDefaultGraph(g);
    }

    @Override
    public void flush() {
        IO.flush(this.out);
    }

    @Override
    public void close() {
        IO.flush(this.out);
    }
}

