/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.HitLARQ;
import com.hp.hpl.jena.query.larq.ScoreTest;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.openjena.atlas.iterator.IteratorTruncate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexLARQ {
    protected final IndexReader reader;
    protected final QueryParser luceneQueryParser;
    protected final Analyzer analyzer;

    public IndexLARQ(IndexReader r) {
        this(r, (Analyzer)new StandardAnalyzer());
    }

    public IndexLARQ(IndexReader r, Analyzer a) {
        this.reader = r;
        this.analyzer = a;
        this.luceneQueryParser = null;
    }

    @Deprecated
    public IndexLARQ(IndexReader r, QueryParser qp) {
        this.reader = r;
        this.analyzer = qp.getAnalyzer();
        this.luceneQueryParser = qp;
    }

    public NodeIterator searchModelByIndex(String queryString) {
        return this.searchModelByIndex(null, queryString);
    }

    public NodeIterator searchModelByIndex(Model model, String queryString) {
        return this.searchModelByIndex(model, queryString, 0.0f);
    }

    public NodeIterator searchModelByIndex(final Model model, String queryString, float scoreLimit) {
        Map1<HitLARQ, RDFNode> converter = new Map1<HitLARQ, RDFNode>(){

            public RDFNode map1(HitLARQ x) {
                return ModelUtils.convertGraphNodeToRDFNode(x.getNode(), model);
            }
        };
        Object iter = new Map1Iterator((Map1)converter, this.search(queryString));
        if (scoreLimit > 0.0f) {
            iter = new IteratorTruncate(new ScoreTest(scoreLimit), iter);
        }
        NodeIteratorImpl nIter = new NodeIteratorImpl((Iterator)iter, null);
        return nIter;
    }

    public boolean hasMatch(String queryString) {
        Iterator<HitLARQ> iter = this.search(queryString);
        return iter.hasNext();
    }

    public Iterator<HitLARQ> search(String queryString) {
        try {
            IndexSearcher searcher = new IndexSearcher(this.reader);
            Query query2 = this.getLuceneQueryParser().parse(queryString);
            Hits hits = searcher.search(query2);
            Map1<Hit, HitLARQ> converter = new Map1<Hit, HitLARQ>(){

                public HitLARQ map1(Hit object) {
                    return new HitLARQ(object);
                }
            };
            Iterator iterHits = hits.iterator();
            Map1Iterator iter = new Map1Iterator((Map1)converter, iterHits);
            return iter;
        }
        catch (Exception e2) {
            throw new ARQLuceneException("search", e2);
        }
    }

    public HitLARQ contains(Node node, String queryString) {
        try {
            Iterator<HitLARQ> iter = this.search(queryString);
            while (iter.hasNext()) {
                HitLARQ x = iter.next();
                if (x == null || !x.getNode().equals((Object)node)) continue;
                return x;
            }
            return null;
        }
        catch (Exception e2) {
            throw new ARQLuceneException("contains", e2);
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception e2) {
            throw new ARQLuceneException("close", e2);
        }
    }

    public final IndexReader getLuceneReader() {
        return this.reader;
    }

    public final QueryParser getLuceneQueryParser() {
        if (this.luceneQueryParser != null) {
            return this.luceneQueryParser;
        }
        return new QueryParser("index", this.analyzer);
    }
}

