/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public abstract class E_OneOfBase
extends ExprFunctionN {
    private Expr expr;
    private ExprList possibleValues;

    protected E_OneOfBase(String name, Expr expr, ExprList args) {
        super(name, E_OneOfBase.fixup(expr, args));
        this.expr = expr;
        this.possibleValues = args;
    }

    private static ExprList fixup(Expr expr2, ExprList args) {
        ExprList allArgs = new ExprList(expr2);
        allArgs.addAll(args);
        return allArgs;
    }

    public Expr getLHS() {
        return this.expr;
    }

    public ExprList getRHS() {
        return this.possibleValues;
    }

    protected boolean evalOneOf(Binding binding, FunctionEnv env) {
        NodeValue nv = this.expr.eval(binding, env);
        ExprEvalException error = null;
        for (Expr inExpr : this.possibleValues) {
            try {
                NodeValue maybe = inExpr.eval(binding, env);
                if (!NodeValue.sameAs(nv, maybe)) continue;
                return true;
            }
            catch (ExprEvalException ex) {
                error = ex;
            }
        }
        if (error != null) {
            throw error;
        }
        return false;
    }

    protected boolean evalNotOneOf(Binding binding, FunctionEnv env) {
        return !this.evalOneOf(binding, env);
    }
}

