#' Nigeria Randomized Response Survey Experiment on Social Connections to Armed
#' Groups
#' 
#' This data set is a subset of the data from the randomized response technique
#' survey experiment conducted in Nigeria to study civilian contact with armed
#' groups. The survey was implemented by Blair (2014).
#' 
#' @name nigeria-data
#' @usage data(nigeria)
#' @format A data frame containing 2457 observations.  The variables are:
#' \itemize{ \item \code{Quesid}: Survey ID of civilian respondent.  \item
#' \code{rr.q1}: Randomized response survey item using the Forced Response
#' Design asking the respondent whether they hold direct social connections
#' with members of armed groups. 0 if no connection; 1 if connection.  \item
#' \code{cov.age}: Age of the respondent.  \item \code{cov.asset.index}: The
#' number of assets owned by the respondent from an index of nine assets
#' including radio, T.V., motorbike, car, mobile phone, refrigerator, goat,
#' chicken, and cow.  \item \code{cov.married}: Marital status. 0 if single; 1
#' if married.  \item \code{cov.education}: Education level of the respondent.
#' 1 if no school; 2 if started primary school; 3 if finished primary school; 4
#' if started secondary school; 5 if finished secondary school; 6 if started
#' polytechnic or college; 7 if finished polytechnic or college; 8 if started
#' university; 9 if finished university; 10 if received graduate (masters or
#' Ph.D) education.  \item \code{cov.female}: Gender. 0 if male; 1 if female.
#' \item \code{civic}: Whether or not the respondent is a member of a civic
#' group in their communities, such as youth groups , women's groups, or
#' community development committees.  }
#' @references Blair, G. (2014). "Why do civilians hold bargaining power in
#' state revenue conflicts? Evidence from Nigeria."
#' 
#' Blair, Graeme, Kosuke Imai and Yang-Yang Zhou. (2014) "Design and Analysis
#' of the Randomized Response Technique."  \emph{Working Paper.} Available at
#' \url{http://imai.princeton.edu/research/randresp.html}.
#' @source Blair, Graeme, Kosuke Imai and Yang-Yang Zhou. (2014) Replication
#' data for: Design and Analysis of the Randomized Response Technique.
#' @keywords dataset
NULL
