% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_opal.R
\name{auth_opal}
\alias{auth_opal}
\title{Authentification in OPAL API}
\usage{
auth_opal(api_user = NULL, api_password = NULL, endpoint = NULL)
}
\arguments{
\item{api_user}{A character value of the username in the OPAL.}

\item{api_password}{A character value of the password in the OPAL.}

\item{endpoint}{A string of endpoint of LMS Opal; by default it is got from
environment variable \code{RQTI_API_ENDPOINT}. To set a global environment
variable, you need to call \code{Sys.setenv(RQTI_API_ENDPOINT='xxxxxxxxxxxxxxx')}
or you can put these command into .Renviron.}
}
\value{
A character string with Opal user id
}
\description{
Function \code{auth_opal()} performs the necessary authentication steps in OPAL
API. If the authentication is successful, the function sets the token value
in the system environment and returns the user's identity key in OPAL. The
token value is required to access the OPAL API system.
}
\section{Authentication}{
 To use OPAL API, you need to provide your
OPAL-username and password. This package uses system credential store
'keyring' to store user's name and password. After the first successful
access to the OPAL API, there is no need to specify the username and
password again, they will be extracted from the system credential store
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
auth_opal()
\dontshow{\}) # examplesIf}
}
