% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpmpopulationpmf.R
\name{rpmpopulationpmf}
\alias{rpmpopulationpmf}
\title{Compute the population distribution of pairs and singles from a Revealed Preference Matchings Model}
\usage{
rpmpopulationpmf(
  object,
  N = 2000,
  num_women = NULL,
  num_men = NULL,
  pmfW = NULL,
  pmfM = NULL,
  verbose = FALSE
)
}
\arguments{
\item{object}{list; an object of class\code{rpm} that is typically the result of a call to \code{rpm()}.}

\item{N}{integer; The total population size. This must be set. The number of women and men are derived from the
(weighted) data.}

\item{num_women}{integer; (Optional) The number of women in the population.}

\item{num_men}{integer; (Optional) The number of men in the population.}

\item{pmfW}{vector; (Optional) The population proportions of the numbers of women of each type. 
This should be compatible with the type in the object.}

\item{pmfM}{vector; (Optional) The population proportions of the numbers of men of each type. 
This should be compatible with the type in the object.}

\item{verbose}{logical; Should verbose messages be printed out.}
}
\value{
A list of data.frame, each a simulation from the population.
}
\description{
\code{\link{rpmpopulationpmf}} computes the probability mass function for a population of the pairs and singles
from a Revealed Preference Matchings Model based on arbitary availability distribution and 
preferences. It is typically based on the estimate from a \code{rpm()} call.
}
\details{
The function \code{\link{rpm}} is used to fit a revealed preference model
for men and women of certain
characteristics (or shared characteristics) of people of the opposite sex.
The model assumes a one-to-one stable matching using an observed set of
matchings and a set of (possibly dyadic) covariates to 
estimate the parameters for
linear equations of utilities.
It does this using a large-population likelihood based on ideas from Menzel (2015).

The model represents the dyadic utility functions as deterministic linear utility functions of
dyadic variables. These utility functions are functions of observed characteristics of the women
and men.
These functions are entered as terms in the function call
to \code{\link{rpm}}. This function simulates from such a model.
}
\examples{
library(rpm)
data(fauxmatching)
\donttest{
fit <- rpm(~match("edu") + WtoM_diff("edu",3),
          Xdata=fauxmatching$Xdata, Zdata=fauxmatching$Zdata,
          X_w="X_w", Z_w="Z_w",
          pair_w="pair_w", pair_id="pair_id", Xid="pid", Zid="pid",
          sampled="sampled")
a <- rpmpopulationpmf(fit)
}
}
\references{
Goyal, Handcock, Jackson. Rendall and Yeung (2023).
\emph{A Practical Revealed Preference Model for Separating Preferences and Availability Effects in Marriage Formation}
\emph{Journal of the Royal Statistical Society}, A. \doi{10.1093/jrsssa/qnad031} 
Menzel, K. (2015).
\emph{Large Matching Markets as Two-Sided Demand Systems}
Econometrica, Vol. 83, No. 3 (May, 2015), 897-941.
}
\keyword{models}
