% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microsimulate.rpm.R
\name{microsimulate}
\alias{microsimulate}
\title{Micro simulate a population from a Revealed Preference Matchings Model}
\usage{
microsimulate(
  object,
  nsim = 1,
  seed = NULL,
  pmfW_N = NULL,
  pmfM_N = NULL,
  large.population = TRUE,
  bootstrap = FALSE,
  control = control.rpm(),
  counts.only = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{object}{list; an object of class\code{rpm} that is typically the result of a call to \code{rpm()}.}

\item{nsim}{Number of matchings to be randomly drawn from the given
model on the set of all matchings / singles.}

\item{seed}{integer; (Optional) random number seed.}

\item{pmfW_N}{vector; The population count of the number of women of each type. 
This should be compatible with the type in the object.}

\item{pmfM_N}{vector; The population count of the number of men of each type. 
This should be compatible with the type in the object.}

\item{large.population}{logical; If TRUE a large population approximation is used to generate
the matchings (rather than the individual level generation of utilities). This is much faster and
uses a lot less memory. It is TRUE by default. If used, a sample is drawn rather than the
population being returned. The sample size is controlled by \code{pmfW_N} and \code{pmfM_N}.}

\item{bootstrap}{logical; If TRUE the original population is sampled from. If FALSE the
population underlying the fitted model is sampled from.}

\item{control}{A list of control parameters for algorithm tuning. Constructed using
\code{\link{control.rpm}}, which should be consulted for specifics.}

\item{counts.only}{logical; If TRUE only the matrices of counts and the PMF of the population of households is returned.
If FALSE 
It is FALSE by default.}

\item{verbose}{logical; Should verbose messages be printed out.}
}
\value{
A list of lists, each a simulation from the population. Each of the simulation lists contains
components \code{population} being a list with components \code{Xdata} and \code{Zdata} (for use with \code{rpm()}).
}
\description{
\code{\link{microsimulate}} simulates a population of the pairs and singles
from a Revealed Preference Matchings Model. It is typically based on the estimate from a \code{rpm()} call.
}
\details{
The function requites the numbers of women of each type and the number of men of each type to be specified. 

The function \code{\link{rpm}} is used to fit a revealed preference model
for men and women of certain
characteristics (or shared characteristics) of people of the opposite sex.
The model assumes a one-to-one stable matching using an observed set of
matchings and a set of (possibly dyadic) covariates to 
estimate the parameters for
linear equations of utilities.
It does this using an large-population likelihood based on ideas from Dagsvik (2000), Menzel (2015) and Goyal et al (2023).

The model represents the dyadic utility functions as deterministic linear utility functions of
dyadic variables. These utility functions are functions of observed characteristics of the women
and men.
These functions are entered as terms in the function call
to \code{\link{rpm}}. This function simulates a population from such a model.
}
\examples{
library(rpm)
\donttest{
data(fauxmatching)
fit <- rpm(~match("edu") + WtoM_diff("edu",3),
          Xdata=fauxmatching$Xdata, Zdata=fauxmatching$Zdata,
          X_w="X_w", Z_w="Z_w",
          pair_w="pair_w", pair_id="pair_id", Xid="pid", Zid="pid",
          sampled="sampled")
num_women = fit$N*exp(fit$gw)
num_men   = fit$N*exp(fit$gm)
pmfW_N <- round(fit$pmfW * num_women)
pmfM_N <- round(fit$pmfM * num_men)
a <- microsimulate(fit, pmfW_N=pmfW_N, pmfM_N=pmfM_N)
}
}
\references{
Goyal, Shuchi; Handcock, Mark S.; Jackson, Heide M.; Rendall, Michael S. and Yeung, Fiona C. (2023).
\emph{A Practical Revealed Preference Model for Separating Preferences and Availability Effects in Marriage Formation}
\emph{Journal of the Royal Statistical Society}, A. \doi{10.1093/jrsssa/qnad031} 

Dagsvik, John K. (2000) \emph{Aggregation in Matching Markets} \emph{International Economic Review}, Vol. 41, 27-57.
JSTOR: https://www.jstor.org/stable/2648822, \doi{10.1111/1468-2354.00054}

Menzel, Konrad (2015).
\emph{Large Matching Markets as Two-Sided Demand Systems}
Econometrica, Vol. 83, No. 3 (May, 2015), 897-941. \doi{10.3982/ECTA12299}
}
\keyword{models}
