% Generated by roxygen2 (4.0.1): do not edit by hand
\name{query_master}
\alias{query_day}
\alias{query_interval}
\alias{query_master}
\alias{query_month}
\alias{query_week}
\alias{query_year}
\alias{sum_day}
\alias{sum_interval}
\alias{sum_master}
\alias{sum_month}
\alias{sum_week}
\alias{sum_year}
\title{Query data and aggregate data}
\usage{
query_master(db, time, col, prop, columns = "name", time.range = NULL,
  filter = NULL, phase = 4)

query_interval(db, ...)

query_day(db, ...)

query_week(db, ...)

query_month(db, ...)

query_year(db, ...)

sum_master(db, time, col, prop, columns = "name", time.range = NULL,
  filter = NULL, phase = 4)

sum_interval(db, ...)

sum_day(db, ...)

sum_week(db, ...)

sum_month(db, ...)

sum_year(db, ...)
}
\arguments{
\item{db}{PLEXOS database object}

\item{time}{character. Table to query from (interval, day, week, month, year)}

\item{col}{character. Collection to query}

\item{prop}{character. Property to query}

\item{columns}{character. Data columns to query or aggregate by (defaults to \code{name})}

\item{time.range}{character. Range of dates (Give in 'ymdhms' or 'ymd' format)}

\item{filter}{list. Used to filter by data columns (see details)}

\item{phase}{integer. PLEXOS optimization phase (1-LT, 2-PASA, 3-MT, 4-ST)}

\item{...}{parameters passed from shortcut functions to master (all except \code{time})}
}
\value{
A data frame that contains data summarized/aggregated by scenario.
}
\description{
This collection of functions retrieves data from the processed PLEXOS solutions and
returns it in a convenient format.
}
\details{
The family \code{query_*} returns the raw data in the databases, while \code{sum_*}
aggregates the data according to \code{columns}.

The functions \code{*_day}, \code{*_week}, \code{*_month} and \code{*_year} are
shortcuts for the corresponding, \code{*_master} function.

The following is a list of valid items for \code{columns} and filtering. Additionally,
\code{time} can be specified for summary data (interval data always includes \code{time}).
\itemize{
  \item{\code{category}}
  \item{\code{property}}
  \item{\code{name} (default for columns)}
  \item{\code{parent}}
  \item{\code{category}}
  \item{\code{region} (only meaningful for generators)}
  \item{\code{zone} (only meaningful for generators)}
  \item{\code{period_type_id}}
  \item{\code{band_id}}
  \item{\code{sample_id}}
  \item{\code{timeslice_id}}
}

If defined, the \code{filter} parameter must be a \code{list}. The elements must be chracter
vectors and need to have a valid column name (see previous bullet points). For example, one
could define it as follows:

\code{filter = list(name = c("Generator1", "Generator2"), region = "Region1")}

To filter by time use the \code{time.range} parameter, instead of adding it as an entry in the
\code{filter} parameter.

If a scenario has multiple databases, the data will be aggregated automatically. If two or more
databases within the same scenario have overlapping time periods, the default is to select the
data from the last database (execute \code{summary(db)} so see the order). To change this behavior
set the global option \code{rplexos.tiebreak} to \code{first}, \code{last}, or \code{all} to
select data from the first database, the last one or keep all of them.
}
\seealso{
\code{\link{plexos_open}} to create the PLEXOS database object
}

