% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_as251.R
\name{as251StudentT}
\alias{as251StudentT}
\title{Algorithm AS 251: Student T Distribution}
\usage{
as251StudentT(
  lower,
  upper,
  sigma,
  ...,
  df,
  eps = 1e-06,
  errorControl = c("strict", "halvingIntervals"),
  intervalSimpsonsRule = 0
)
}
\arguments{
\item{lower}{Lower limits of integration. Array of N dimensions}

\item{upper}{Upper limits of integration. Array of N dimensions}

\item{sigma}{Values defining correlation structure. Array of N dimensions}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{df}{Degrees of Freedom. Use 0 for infinite D.F.}

\item{eps}{desired accuracy. Defaults to 1e-06}

\item{errorControl}{error control. If set to 1, strict error control based on
fourth derivative is used. If set to zero, error control based on halving intervals is used}

\item{intervalSimpsonsRule}{Interval width for Simpson's rule. Value of zero caused a default .24 to be used}
}
\description{
Calculates the Multivariate Normal Distribution with Product Correlation Structure published
by Charles Dunnett, Algorithm AS 251.1 Appl.Statist. (1989), Vol.38, No.3 \doi{10.2307/2347754}.
}
\details{
For a multivariate normal vector with correlation structure
defined by rho(i,j) = bpd(i) * bpd(j), computes the probability
that the vector falls in a rectangle in n-space with error
less than eps.

This function calculates the \code{bdp} value from \code{sigma}, determines the right \code{inf} value and calls \code{\link{mvstud}}.
}
