% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rowr.R
\name{rowApply}
\alias{rowApply}
\title{Applies a function row-wise on any data object.}
\usage{
rowApply(data, fun, ...)
}
\arguments{
\item{data}{any \code{R} object}

\item{fun}{the function to evaluate}

\item{...}{additional arguments to pass to \code{fun}}
}
\description{
Essentially functions as a \code{MARGIN=1} \code{\link{apply}} apply but also
works on data objects without 2 dimensions such as lists and vectors.
}
\examples{
rowApply(list(1,2,3),function (x) sum(unlist(x)))
df<-data.frame(a=c(1,2,3),b=c(1,2,3))
rowApply(df,sum)
}

