% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rowr.R
\name{rollApply}
\alias{rollApply}
\title{Applies a function over a rolling window on any data object.}
\usage{
rollApply(data, fun, window = len(data), minimum = 1, align = "left", ...)
}
\arguments{
\item{data}{any \code{R} object}

\item{fun}{the function to evaluate}

\item{window}{window width defining the size of the subset available to the
fun at any given point}

\item{minimum}{minimum width of the window.  Will not return results if the
window is truncated below this value at the end of the data set}

\item{align}{whether to align the window right or left}

\item{...}{additional arguments to pass to \code{fun}}
}
\description{
Simple generalized alternative to \code{\link[zoo]{rollapply}} in package
\code{\link[zoo]{zoo}} with the advantage that it works on any type of data
structure (vector, list, matrix, etc) instead of requiring a \code{zoo}
object.
}
\examples{
rollApply(1:100,sum,minimum=2,window=2)
rollApply(c(1,2,3),sum)
##6 5 3
rollApply(c(1,2,3,4,5,6,7,8,9),sum)
##45 44 42 39 35 30 24 17  9
rollApply(c(1,2,3,4,5,6,7,8,9),sum,window=2)
##3  5  7  9 11 13 15 17  9
rollApply(list(1,2,3,4,5,6,7,8,9),function(x) sum(unlist(x)),window=2,minimum=2)
##3  5  7  9 11 13 15 17
cbind(women,Rolling3=rollApply(women,fun=function(x) mean(x$weight),window=3,align='right'))
}

