% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlays.R
\name{osm.polygon}
\alias{osm.polygon}
\title{Overlay a polygon on an OSM plot}
\usage{
osm.polygon(x, y = NULL, epsg = 4326, toepsg = 3857, ...)
}
\arguments{
\item{x}{X coordinate vector or object as parsed by \code{xy.coords}}

\item{y}{Y coordinate vector}

\item{epsg}{EPSG code of the supplied coordinates}

\item{toepsg}{EPSG code of the projected coordinates to be ploted}

\item{...}{Args passed on to \code{polygon}}
}
\description{
Plot a polygon on a plot created by \link{osm.plot}. This is a simple wrapper around
\code{polygon()}.
}
\examples{
library(rosm)
library(prettymapr)
locs <- geocode(c("wolfville, ns", "kentville, ns", "halifax, ns"))
prettymap({
  osm.plot(searchbbox("nova scotia"))
  osm.polygon(locs$lon, locs$lat)
})

}

