% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findall.R
\name{findall}
\alias{findall}
\title{Invoke a query several times}
\usage{
findall(
  query = call("member", expression(X), list(quote(a), "b", 3L, 4, TRUE,
    expression(Y))),
  options = list(portray = FALSE)
)
}
\arguments{
\item{query}{an R call. The R call consists of symbols, integers and real numbers,
character strings, boolean values, expressions, lists, and other calls.
Vectors of booleans, integers, floating point numbers, and strings with
length \emph{N} > 1 are translated to prolog compounds !/N, \%/N, #/N and $$/N,
respectively. The names can be modified with the options below.}

\item{options}{This is a list of options controlling translation from and to prolog.
\itemize{
\item \emph{boolvec} (see option rolog.boolvec, default is !) is the name of the
prolog compound for vectors of booleans.
\item \emph{intvec}, \emph{realvec}, \emph{charvec} define the compound names for vectors of
integers, doubles and strings, respectively (defaults are \%, # and $$).
\item If \emph{scalar} is \code{TRUE} (default), vectors of length 1 are translated to
scalar prolog elements. If \emph{scalar} is \code{FALSE}, vectors of length 1 are
also translated to compounds.
}}
}
\value{
If the query fails, an empty list is returned. If the query
succeeds \emph{N} >= 1 times, a list of length \emph{N} is returned, each element
being a list of conditions for each solution, see \code{\link[=once]{once()}}.
}
\description{
Invoke a query several times
}
\examples{
# This query returns a list stating that it works if X = a, "b", ...
findall(call("member", expression(X), list(quote(a), "b", 3L, 4, TRUE, NULL, NA)))

# Continued
findall(call("member", expression(X), list(call("sin", call("/", quote(pi), 2)), expression(Y))))

# The same using simplified syntax
q <- quote(member(.X, ""[a, "b", 3L, 4, TRUE, NULL, NA, sin(pi/2), .Y]))
findall(as.rolog(q))

}
\seealso{
\code{\link[=once]{once()}}
for a single query

\code{\link[=query]{query()}}, \code{\link[=submit]{submit()}}, and \code{\link[=clear]{clear()}} for fine-grained control over
non-deterministic queries

\code{\link[=rolog_options]{rolog_options()}}
}
