% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_source.R, R/code_sources.R
\name{code_source}
\alias{code_source}
\alias{code_sources}
\title{Add one or more codes to one or more sources}
\usage{
code_source(
  input,
  codes,
  indices = NULL,
  output = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  rlWarn = rock::opts$get(rlWarn),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)

code_sources(
  input,
  codes,
  output = NULL,
  indices = NULL,
  outputPrefix = "",
  outputSuffix = "_coded",
  recursive = TRUE,
  filenameRegex = ".*",
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{input}{The source, or list of sources, as
produced by one of the \code{loading_sources} functions.}

\item{codes}{A named character vector, where each element
is the code to be added to the matching utterance, and
the corresponding name is either an utterance identifier
(in which case the utterance with that identifier will be
coded with that code), a code (in which case all utterances
with that code will be coded with the new code as well), a
digit (in which case the utterance at that line number in
the source will be coded with that
code), or a regular expression, in which case all utterances
matching that regular expression will be coded with that
source. If specifying an utterance ID or code, make sure
that the code delimiters are included (normally, two square
brackets).}

\item{indices}{If \code{input} is a source as loaded by
\code{loading_sources}, \code{indices} can be used to pass a logical
vector of the same length as \code{input}
that indicates to which utterance the code in \code{codes} should be
applied. Note that if \code{indices} is provided, only the first
element of \code{codes} is used, and its name is ignored.}

\item{output}{If specified, the coded source will be written here.}

\item{preventOverwriting}{Whether to prevent overwriting existing files.}

\item{rlWarn}{Whether to let \code{\link[=readLines]{readLines()}} warn, e.g. if files do not end
with a newline character.}

\item{encoding}{The encoding to use.}

\item{silent}{Whether to be chatty or quiet.}

\item{outputPrefix, outputSuffix}{A prefix and/or suffix to prepend and/or
append to the filenames to distinguish them from the input filenames.}

\item{recursive}{Whether to also read files from all subdirectories
of the \code{input} directory}

\item{filenameRegex}{Only input files matching this patterns will be read.}
}
\value{
Invisibly, the coded source object.
}
\description{
These functions add codes to one or more
sources that were read with one of the
\code{loading_sources} functions.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Parse single example source
loadedExample <- rock::load_source(exampleFile);

### Show line 71
cat(loadedExample[71]);

### Specify the rules to code all utterances
### containing "Ipsum" with the code 'ipsum' and
### all utterances containing the code
codeSpecs <-
  c("(?i)ipsum" = "ipsum",
    "BC|AD|\\\\d\\\\d\\\\d\\\\ds" = "timeRef");

### Apply rules
codedExample <- code_source(loadedExample,
                            codeSpecs);

### Show line 71
cat(codedExample[71]);

### Also add code "foo" to utterances with code 'ipsum'
moreCodedExample <- code_source(codedExample,
                                c("[[ipsum]]" = "foo"));

### Show line 71
cat(moreCodedExample[71]);

### Use the 'indices' argument to add the code 'bar' to
### line 71
overCodedExample <- code_source(moreCodedExample,
                                "bar",
                                indices=71);

cat(overCodedExample[71]);

}
