% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{selection}
\alias{selection}
\title{Create selection (non-outlying) vector from model}
\usage{
selection(data, yvar, model, cutoff, bias_correction = NULL)
}
\arguments{
\item{data}{A dataframe.}

\item{yvar}{A character vector of length 1 that refers to the name of the
dependent variable in the data set.}

\item{model}{A model object of \link{class} \code{\link[ivreg]{ivreg}} whose
parameters are used to calculate the residuals.}

\item{cutoff}{A numeric cutoff value used to judge whether an observation
is an outlier or not. If its absolute value is larger than the cutoff value,
the observations is classified as being an outlier.}

\item{bias_correction}{A numeric factor used to correct the estimate of
sigma under the null hypothesis of no outliers or \code{NULL} if no
correction should be done.}
}
\value{
A list with five elements. The first four are vectors whose length
equals the number of observations in the data set. Unlike the residuals
stored in a model object (usually accessible via \code{model$residuals}), it
does not ignore observations where any of y, x or z are missing. It instead
sets their values to \code{NA}.

The first element is a double vector containing the residuals for each
observation based on the model estimates. The second element contains the
standardised residuals, the third one a logical vector with \code{TRUE} if
the observation is judged as not outlying, \code{FALSE} if it is an outlier,
and \code{NA} if any of y, x, or z are missing. The fourth element of the
list is an integer vector with three values: 0 if the observations is judged
to be an outlier, 1 if not, and -1 if missing. The fifth and last element
stores the \code{\link[ivreg]{ivreg}} model object based on which the four
vectors were calculated.
}
\description{
\code{selection} uses the data and model objects to create a list with five
elements that are used to determine whether the observations are judged as
outliers or not.
}
\section{Warning}{

Unlike the residuals stored in a model object (usually accessible via
\code{model$residuals}), this function returns vectors of the same length as
the original data set even if any of the y, x, or z variables are missing.
The residuals for those observations are set to \code{NA}.
}

\keyword{internal}
