% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_apps.R
\name{simulation_app}
\alias{simulation_app}
\title{Open a 'shiny' app for exploring mediation analysis on simulated data}
\usage{
simulation_app()
}
\value{
No return value, the function is called for its side effect of starting a
\pkg{shiny} app.
}
\description{
Open a \pkg{shiny} app for exploring the behavior of various bootstrap
procedures for mediation analysis on simulated data.
}
\details{
The default settings are similar to one of the simulation designs of Alfons,
Ates & Groenen (2022a).  You can adjust the total number of observations,
the values of the coefficients in the (simple) mediation model, the number
of outliers, as well as outlier scaling factors and shifts in the individual
variables.

For each selected method, the bootstrap distribution of the indirect
effect is shown together with a shaded area representing the 95\% confidence
interval.  If the app does not update quickly enough, try to reduce the
number of bootstrap samples.
}
\examples{
\dontrun{

# start graphical user interface
simulation_app()
}

}
\references{
Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2022a) A Robust Bootstrap Test
for Mediation Analysis.  \emph{Organizational Research Methods},
\bold{25}(3), 591--617.  doi:10.1177/1094428121999096.

Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2022b) Robust Mediation
Analysis: The \R Package \pkg{robmed}.  \emph{Journal of Statistical
Software}, \bold{103}(13), 1--45.  doi:10.18637/jss.v103.i13.

Preacher, K.J. and Hayes, A.F. (2004) SPSS and SAS Procedures for Estimating
Indirect Effects in Simple Mediation Models.  \emph{Behavior Research
Methods, Instruments, & Computers}, \bold{36}(4), 717--731.
doi:10.3758/bf03206553.

Preacher, K.J. and Hayes, A.F. (2008) Asymptotic and Resampling Strategies
for Assessing and Comparing Indirect Effects in Multiple Mediator Models.
\emph{Behavior Research Methods}, \bold{40}(3), 879--891.
doi:10.3758/brm.40.3.879.

Yuan, Y. and MacKinnon, D.P. (2014) Robust Mediation Analysis Based on
Median Regression.  \emph{Psychological Methods}, \bold{19}(1), 1--20.
doi:10.1037/a0033820.

Zu, J. and Yuan, K.-H. (2010) Local Influence and Robust Procedures for
Mediation Analysis.  \emph{Multivariate Behavioral Research}, \bold{45}(1),
1--44.  doi:10.1080/00273170903504695.
}
\seealso{
\code{\link{test_mediation}}
}
\author{
Andreas Alfons
}
