% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.testMediation}
\alias{coef.bootTestMediation}
\alias{coef.fitMediation}
\alias{coef.testMediation}
\title{Coefficients in (robust) mediation analysis}
\usage{
\method{coef}{testMediation}(object, parm = NULL, ...)

\method{coef}{bootTestMediation}(object, parm = NULL, type = c("boot",
  "data"), ...)

\method{coef}{fitMediation}(object, parm = NULL, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"\link{testMediation}"}
containing results from (robust) mediation analysis, or an object inheriting
from class \code{"\link{fitMediation}"} containing a (robust) mediation
model fit.}

\item{parm}{an integer, character or logical vector specifying the
coefficients to be extracted, or \code{NULL} to extract all coefficients.}

\item{type}{a character string specifying whether to extract the means
of the bootstrap distribution (\code{"boot"}; the default), or the
coefficient estimates based on the full data set (\code{"data"}).}

\item{\dots}{additional arguments are currently ignored.}
}
\value{
A numeric vetor containing the requested coefficients.
}
\description{
Extract coefficients from models computed in (robust) mediation analysis.
}
\author{
Andreas Alfons
}
\seealso{
\code{\link{testMediation}}, \code{\link{fitMediation}},
\code{\link[=confint.testMediation]{confint}}
}
\keyword{utilities}

