% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpc.R
\name{bpc}
\alias{bpc}
\title{Backwards pivot coordinates and their inverse}
\usage{
bpc(X, base = exp(1))
}
\arguments{
\item{X}{object of class data.frame. Positive values only.}

\item{base}{a positive number: the base with respect to which logarithms are computed. Defaults to exp(1).}
}
\value{
\item{Coordinates}{array of orthonormal coordinates.} 
\item{Coordinates.ortg}{array of orthogonal coordinates (without the normalising constant sqrt(i/i+1).} 
\item{Contrast.matrix}{contrast matrix corresponding to the orthonormal coordinates.}
\item{Base}{the base with respect to which logarithms are computed.}
\item{Levels}{the order of compositional parts.}
}
\description{
Backwards pivot coordinate representation of a set of compositional ventors as a special case of isometric logratio coordinates and their inverse mapping.
}
\details{
bpc

Backwards pivot coordinates map D-part compositional data from the simplex into a (D-1)-dimensional real space isometrically. The first coordinate has form of pairwise logratio log(x2/x1) and serves as an alternative to additive logratio transformation with part x1 being the rationing element. The remaining coordinates are structured as detailed in Nesrstova et al. (2023). 
Consequently, when a specific pairwise logratio is of the main interest, the respective columns have to be placed at the first (the compositional part in denominator of the logratio, the rationing element) and the second position (the compositional part in numerator) in the data matrix X.
}
\examples{
data(expenditures)

# default setting with ln()
bpc(expenditures)

# logarithm of base 2
bpc(expenditures, base = 2)
}
\references{
Hron, K., Coenders, G., Filzmoser, P., Palarea-Albaladejo, J., Famera, M., Matys Grygar, M. (2022). Analysing pairwise logratios revisited. Mathematical Geosciences 53, 1643 - 1666.

Nesrstova, V., Jaskova, P., Pavlu, I., Hron, K., Palarea-Albaladejo, J., Gaba, A., Pelclova, J., Facevicova, K. (2023). Simple enough, but not simpler: Reconsidering additive logratio coordinates in compositional analysis. Submitted
}
\seealso{
\code{\link{bpcTab}} 
\code{\link{bpcTabWrapper}} 
\code{\link{bpcPca}}
\code{\link{bpcReg}}
}
\author{
Kamila Facevicova
}
\keyword{coordinates}
\keyword{multivariate}
