% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdcm.R
\name{rdcm}
\alias{rdcm}
\title{relative difference between covariance matrices}
\usage{
rdcm(x, y)
}
\arguments{
\item{x}{matrix or data frame}

\item{y}{matrix or data frame of the same size as x.}
}
\value{
the error measures value
}
\description{
The sample covariance matrices are computed from compositions expressed in the same isometric logratio coordinates.
}
\details{
The difference in covariance structure is based on the Euclidean distance between both covariance estimations.
}
\examples{
data(expenditures)
x <- expenditures
x[1,3] <- NA
xi <- impKNNa(x)$xImp
rdcm(expenditures, xi)
}
\references{
Hron, K. and Templ, M. and Filzmoser, P. (2010) Imputation of
missing values for compositional data using classical and robust methods
\emph{Computational Statistics and Data Analysis}, 54 (12),
3095-3107.

Templ, M. and Hron, K. and Filzmoser and Gardlo, A. (2016). 
Imputation of rounded zeros for high-dimensional compositional data. 
\emph{Chemometrics and Intelligent Laboratory Systems}, 155, 183-190.
}
\seealso{
\code{\link{rdcm}}
}
\author{
Matthias Templ
}
\keyword{manip}
