% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balances.R
\name{balances}
\alias{balances}
\title{Balance calculation}
\usage{
balances(x, y)
}
\arguments{
\item{x}{data frame or matrix, typically compositional data}

\item{y}{binary partition}
}
\value{
\item{balances}{The balances represent orthonormal coordinates which allow an interpretation in sense of groups of compositional parts.
                        Output is a matrix, the D-1 colums contain balance coordinates of the observations in the rows.}
        \item{V}{A Dx(D-1) contrast matrix associated with the orthonormal basis, corresponding to the sequential binary partition (in clr coordinates).}
}
\description{
Given a D-dimensional compositional data set and a sequential binary partition,
the function bal calculates the balances in order to express the given data
in the (D-1)-dimensional real space.
}
\details{
The sequential binary partition constructs an orthonormal basis in the (D-1)-dimensional hyperplane
in real space.
}
\examples{
data(expenditures, package = "robCompositions")
y1 <- data.frame(c(1,1,1,-1,-1),c(1,-1,-1,0,0),
                 c(0,+1,-1,0,0),c(0,0,0,+1,-1))
y2 <- data.frame(c(1,-1,1,-1,-1),c(1,0,-1,0,0),
                 c(1,-1,1,-1,1),c(0,-1,0,1,0))
y3 <- data.frame(c(1,1,1,1,-1),c(-1,-1,-1,+1,0),
                 c(-1,-1,+1,0,0),c(-1,1,0,0,0))
y4 <- data.frame(c(1,1,1,-1,-1),c(0,0,0,-1,1),
                 c(-1,-1,+1,0,0),c(-1,1,0,0,0))
y5 <- data.frame(c(1,1,1,-1,-1),c(-1,-1,+1,0,0),
                 c(0,0,0,-1,1),c(-1,1,0,0,0))
b1 <- balances(expenditures, y1)
b2 <- balances(expenditures, y5)
b1$balances
b2$balances

data(machineOperators)
sbp <- data.frame(c(1,1,-1,-1),c(-1,+1,0,0),
                 c(0,0,+1,-1))
balances(machineOperators, sbp)

}
\references{
(Egozcue, J.J., Pawlowsky-Glahn, V. (2005) Groups of parts and their balances in compositional data analysis. Mathematical Geology, 37 (7), 795???828.)
}

