% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdf.R
\name{gdf}
\alias{gdf}
\title{This function retrieves Gauged Daily Flow (gdf).}
\usage{
gdf(id, metadata = FALSE, cl = NULL)
}
\arguments{
\item{id}{station ID number(s), each number should be in the range
[3002,236051].}

\item{metadata}{Logical, FALSE by default. If metadata = TRUE means that the
result for a single station is a list with two elements:
data (the time series) and meta (metadata).}

\item{cl}{(optional) This is a cluster object, created by the parallel
package. This is set to NULL by default, which sends sequential calls to the
server.}
}
\value{
list composed of as many objects as in the list of station ID
numbers. Each object can be accessed using their names or index
(e.g. x[[1]], x[[2]], and so forth). Each object contains a zoo time series.
}
\description{
Given the station ID number(s), this function retrieves data
(time series in zoo format with accompanying metadata) from the WaterML2
service on the NRFA database. Gauged Daily Flow is measured in \eqn{m^3}/s.
}
\examples{
\dontrun{
  gdf(18019)
  gdf(c(54022,54090,54091))
}

}
\author{
Claudia Vitolo
}
