% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_indspatstations.R
\name{npn_indspatstations}
\alias{npn_indspatstations}
\title{Get all observations for a particular species or set of species.}
\usage{
npn_indspatstations(speciesid, stationid, year = NULL, ...)
}
\arguments{
\item{speciesid}{Required. Species id numbers, from 1 to infinity, potentially,
use e.g., c(52, 53, etc.) if more than one species desired (numeric)}

\item{stationid}{Required. Use e.g., c(4881, 4882, etc.) if more than one species desired
(numeric)}

\item{year}{Year (numeric).}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
Observations for each species by date.
}
\description{
Get all observations for a particular species or set of species.
}
\examples{
\dontrun{
npn_indspatstations(speciesid = 35, stationid = c(60, 259), year = 2009)
npn_indspatstations(35, c(60, 259), 2009)
}
}

