% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storm_events.R
\name{storm_events}
\alias{storm_events}
\alias{se_data}
\alias{se_files}
\title{NOAA Storm Events data}
\usage{
se_data(year, type, overwrite = TRUE, ...)

se_files(...)
}
\arguments{
\item{year}{(numeric) a four digit year. see output of \code{se_files()}
for available years. required.}

\item{type}{(character) one of details, fatalities, locations, or
legacy. required.}

\item{overwrite}{(logical) To overwrite the path to store files in or not,
Default: \code{TRUE}}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}
(optional)}
}
\value{
A tibble (data.frame)
}
\description{
NOAA Storm Events data
}
\note{
See \link{stormevents_cache} for managing cached files
}
\examples{
\dontrun{
# get list of files and their urls
res <- se_files()
res
tail(res)

# get data
x <- se_data(year = 2013, type = "details")
x

z <- se_data(year = 1988, type = "fatalities")
z

w <- se_data(year = 2003, type = "locations")
w

leg <- se_data(year = 2003, type = "legacy")
leg
}
}
