% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ersst.R
\name{ersst}
\alias{ersst}
\title{NOAA Extended Reconstructed Sea Surface Temperature (ERSST) data}
\usage{
ersst(year, month, overwrite = TRUE, version = "v5", ...)
}
\arguments{
\item{year}{(numeric) A year. Must be > 1853. The max value is whatever
the current year is. Required}

\item{month}{A month, character or numeric. If single digit (e.g. 8), we
add a zero in front (e.g., 08). Required}

\item{overwrite}{(logical) To overwrite the path to store files in or not,
Default: \code{TRUE}}

\item{version}{(character) ERSST version. one of "v5" (default) or "v4"}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
An \code{ncdf4} object. See \pkg{ncdf4} for parsing the output
}
\description{
NOAA Extended Reconstructed Sea Surface Temperature (ERSST) data
}
\details{
See \link{ersst_cache} for managing cached files

\code{ersst()} currently defaults to use ERSST v5 - you can set v4 or v5
using the \code{version} parameter

If a request is unsuccesful, the file written to disk is deleted before
the function exits.

If you use this data in your research please cite rnoaa
(\code{citation("rnoaa")}), and cite NOAA ERSST (see citations at link above)
}
\examples{
\dontrun{
# October, 2015
ersst(year = 2015, month = 10)

# May, 2015
ersst(year = 2015, month = 5)
ersst(year = 2015, month = "05")

# February, 1890
ersst(year = 1890, month = 2)

# Process data
library("ncdf4")
res <- ersst(year = 1890, month = 2)
## varibles
names(res$var)
## get a variable
ncdf4::ncvar_get(res, "ssta")
}
}
