% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_miss.R
\name{vis_miss}
\alias{vis_miss}
\title{Visualize missingness in a dataframe}
\usage{
vis_miss(x, cluster = FALSE, sort_miss = FALSE)
}
\arguments{
\item{x}{a data.frame}

\item{cluster}{logical TRUE/FALSE. TRUE specifies that you want to use
hierarchical clustering (mcquitty method) to arrange rows according to
missingness. FALSE specifies that you want to leave it as is.}

\item{sort_miss}{logical TRUE/FALSE. TRUE arranges the columns in order of
missingness.}
}
\description{
Gives you an at-a-glance ggplot of the missingness inside a dataframe,
colouring cells according to missingness, where black indicates a present
cell and grey indicates a missing cell. As it returns a \code{ggplot} object,
it is very easy to customize and change labels, and so on.
}
\details{
\code{vis_miss} visualises a data.frame to display missingness. This is
taken from the visdat package, currently only available on github:
\url{https://github.com/tierneyn/visdat}
}
\examples{
\dontrun{
  monitors <- c("ASN00003003", "ASM00094299")
  weather_df <- meteo_pull_monitors(monitors)
  vis_miss(weather_df)
}

}

