% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ncdc_legacy.R
\name{ncdc_legacy}
\alias{ncdc_leg_data}
\alias{ncdc_leg_site_info}
\alias{ncdc_leg_sites}
\alias{ncdc_leg_variables}
\alias{ncdc_legacy}
\title{Search the NOAA NCDC legacy API - main purpose to get ISD daily data.}
\usage{
ncdc_leg_variables(dataset = "isd", variable = NULL, token = NULL, ...)

ncdc_leg_sites(dataset = "isd", state_id = NULL, state_abbrev = NULL,
  country_id = NULL, country_abbrev = NULL, token = NULL, ...)

ncdc_leg_site_info(dataset = "isd", station, token = NULL, ...)

ncdc_leg_data(dataset = "isd", station, variable, start_date, end_date,
  token = NULL, ...)
}
\arguments{
\item{dataset}{Dataset id, one of isd (default), ish, or daily.}

\item{variable}{A variable id.}

\item{token}{Your token. Store as environment variable as NOAA_LEG_TOKEN or option variable
as noaalegtoken.}

\item{...}{Further args passed to \code{\link[httr]{GET}}}

\item{state_id}{State ID}

\item{state_abbrev}{State abbreviation}

\item{country_id}{Country id}

\item{country_abbrev}{Country abbreviation}

\item{station}{A station id.}

\item{start_date,end_date}{Date to start and end search for. Valid formats include, YYYY,
YYYYMM, YYYYMMDD, YYYYMMDDhh, and YYYYMMDDhhmm.}
}
\description{
Search the NOAA NCDC legacy API - main purpose to get ISD daily data.
}
\details{
BEWARE: This service, as far as I can tell, enforces a wait time between successive
data requests of 60 seconds. This is indeed a long time.
}
\examples{
\dontrun{
# Variables
## All variables
ncdc_leg_variables()
## Specific variables
### Air Temperature Observation
ncdc_leg_variables(variable = "TMP")
### Snow Accumulation For The Month
ncdc_leg_variables(variable = "AN1")

# Sites
head( ncdc_leg_sites() )
ncdc_leg_sites(country_id = 1)
ncdc_leg_sites(country_abbrev = 'CA')
ncdc_leg_sites(state_id = 11)
ncdc_leg_sites(state_abbrev = 'HI')
## site info
ncdc_leg_site_info(stationid=71238099999)

# Data
ncdc_leg_data('isd', 71238099999, 'TMP', 200101010000, 200101312359)
ncdc_leg_data('isd', 71238099999, 'TMP', 200101, 200201)
}
}
\references{
\url{http://www7.ncdc.noaa.gov/wsregistration/ws_home.html},
\url{http://www7.ncdc.noaa.gov/rest/},
\url{http://www7.ncdc.noaa.gov/wsregistration/CDOServices.html}
}

