% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_rates.R
\name{get_exchangerate_from}
\alias{get_exchangerate_from}
\title{Retrieves the exchange rate from a specific date.}
\usage{
get_exchangerate_from(table, currency_code, date)
}
\arguments{
\item{table}{specifies which from which table the exchange
rate should be fetched.}

\item{currency_code}{code of the currency for which the
exchange rate should be fetched.}

\item{date}{date from which the exchange rate should
be fetched.}
}
\value{
nbp_api_response object containing the exchange rate
from the specified date.
}
\description{
Retrieves the exchange rate from a specific date.
}
\details{
As exchange rates are not published on the weekends
fetching values from a weekend date will result in a 404
error. In those cases the function returns an error with an
appropriate message.
}
\examples{

\donttest{
  tryCatch({
      ## Fetch the euro exchange rate from a week ago
      response <- get_exchangerate_from("A", "EUR", Sys.Date() - 7)
      ## Preview response content
      response$content
    },
    error = function(e) message(e)
  )
}

}
\seealso{
\url{https://api.nbp.pl/#kursyWalut}

Other rates: 
\code{\link{get_current_exchangerate}()},
\code{\link{get_exchangerate_from_interval}()},
\code{\link{get_last_n_exchangerates}()},
\code{\link{get_todays_exchangerate}()}
}
\concept{rates}
