% Generated by roxygen2 (4.0.1): do not edit by hand
\name{runnbnurl}
\alias{runnbnurl}
\title{Run the constructed url and get data}
\usage{
runnbnurl(service = NULL, tvks = NULL, datasets = NULL, feature = NULL,
  startYear = NULL, endYear = NULL, list = NULL, VC = NULL,
  group = NULL, query = NULL, gridRef = NULL, attributes = FALSE)
}
\arguments{
\item{service}{the service you want to call. One of \code{"obs"} for the
taxonObservations service, \code{"feature"} for the features service,
\code{"taxon"} for the taxa service, \code{"list"} for listing services,
\code{"ancestry"} for taxonomy service and \code{"species"} for the
species service. The first letter is sufficient}

\item{tvks}{a list of TVKs which are strings of 16 alphanumeric characters}

\item{datasets}{a list of dataset keys which are strings of 8 alphanumeric
characters}

\item{feature}{a featureID which is a string of 8 alphanumeric characters}

\item{startYear}{a 4 digit integer year}

\item{endYear}{a 4 digit integer year}

\item{list}{url segment as a string as required to append to the base url to
give the list required as a part of the \code{"list"} service.}

\item{VC}{a string giving a vice-county name (see \code{\link{listVCs}})}

\item{group}{a string giving the name of a group (see \code{\link{listGroups}})}

\item{query}{a string used to perform a taxa search}

\item{gridRef}{a string giving a gridreference in which to search for occurrences}

\item{attributes}{if \code{TRUE} then attribute data is returned}
}
\value{
a JSON object resulting from the call
}
\description{
The URL to call a web-service is constructed using makenbnurl()
This is run and, hopefully, returns a JSON object
}
\examples{
\dontrun{
 json <- runnbnurl(service="obs", tvks="NBNSYS0000007073", datasets="SGB00001",
                   startYear="1990", endYear="2010")
}
}
\author{
Stuart Ball, JNCC \email{stuart.ball@jncc.gov.uk}
}

