% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_normalise_nested_sets.R
\name{rmw_normalise_nested_sets}
\alias{rmw_normalise_nested_sets}
\title{Function to normalise a variable for "average" meteorological conditions in
a nested tibble.}
\usage{
rmw_normalise_nested_sets(
  df_nest,
  variables = NA,
  n_samples = 10,
  replace = TRUE,
  se = FALSE,
  aggregate = TRUE,
  keep_samples = FALSE,
  n_cores = NA,
  verbose = FALSE,
  progress = FALSE
)
}
\arguments{
\item{df_nest}{Nested tibble created by \code{\link{rmw_model_nested_sets}}.}

\item{variables}{Variables to randomly sample. Default is all variables used
for training the model with the exception of \code{date_unix}, the trend term.}

\item{n_samples}{Number of times to sample \code{df} and then predict?}

\item{replace}{Should \code{variables} be sampled with replacement?}

\item{se}{Should the standard error of the predictions be calculated too? 
The standard error method is the "infinitesimal jackknife for bagging" and 
will slow down the predictions significantly.}

\item{aggregate}{Should all the \code{n_samples} predictions be aggregated?}

\item{keep_samples}{When \code{aggregate} is \code{FALSE}, should the 
sampled/shuffled observations be kept?}

\item{n_cores}{Number of CPU cores to use for the model predictions. Default
is system's total minus one.}

\item{verbose}{Should the function give messages?}

\item{progress}{Should a progress bar be displayed?}
}
\value{
Nested tibble.
}
\description{
Function to normalise a variable for "average" meteorological conditions in
a nested tibble.
}
\seealso{
\code{\link{rmw_nest_for_modelling}}, 
\code{\link{rmw_model_nested_sets}}, \code{\link{rmw_model_nested_sets}}, 
\code{\link{rmw_normalise}}.
}
\author{
Stuart K. Grange
}
