% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanMisc.r
\name{stanDxplot}
\alias{stanDxplot}
\title{stanDxplot}
\usage{
stanDxplot(
  x,
  which = NULL,
  rstan = FALSE,
  previous = TRUE,
  plotno = 1,
  rev = FALSE,
  stripsize = 8,
  ...
)
}
\arguments{
\item{x}{an \code{rms} Bayesian fit object}

\item{which}{names of parameters to plot, defaulting to all non-intercepts.  When \code{rstan=FALSE} these are the friendly \code{rms} names, otherwise they are the \code{rstan} parameter names.  If the model fit was run through \code{stackMI} for multiple imputation, the number of traces is multiplied by the number of imputations.  Set to \code{'ALL'} to plot all parameters.}

\item{rstan}{set to \code{TRUE} to use \code{rstan::traceplot} on a (presumed) stored \code{rstan} object in \code{x}, otherwise only real iterations are plotted and parameter values are shown as points instead of lines, with chains separated}

\item{previous}{see details}

\item{plotno}{see details}

\item{rev}{set to \code{TRUE} to reverse direction for faceting chains}

\item{stripsize}{specifies size of chain facet label text, default is 8}

\item{...}{passed to \code{rstan::traceplot}}
}
\value{
\code{ggplot2} object if \code{rstan} object was in \code{x}
}
\description{
Diagnostic Trace Plots
}
\details{
For an \code{rms} Bayesian fit object, uses by default the stored posterior draws to check convergence properties of posterior sampling.  If instead \code{rstan=TRUE}, calls the \code{rstan} \code{traceplot} function on the \code{rstan} object inside the \code{rmsb} object, to check properties of posterior sampling.  If \code{rstan=TRUE} and the \code{rstan} object has been removed and \code{previous=TRUE}, attempts to find an already existing plot created by a previous run of the \code{knitr} chunk, assuming it was the \code{plotno} numbered plot of the chunk.
}
\author{
Frank Harrell
}
