% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanMisc.r
\name{selectedQr}
\alias{selectedQr}
\title{selectedQr}
\usage{
selectedQr(X, not = NULL, corner = FALSE, center = TRUE)
}
\arguments{
\item{X}{a numeric matrix}

\item{not}{an integer vector specifying which columns of \code{X} are to be kept with their original values}

\item{corner}{set to \code{FALSE} to not treat the last column specially.  You may not specify both \code{not} and \code{corner}.}

\item{center}{set to \code{FALSE} to not center columns of \code{X} first}
}
\value{
list with elements \code{X, R, Rinv, xbar} where \code{xbar} is the vector of means (vector of zeros if \code{center=FALSE})
}
\description{
QR Decomposition Preserving Selected Columns
}
\details{
Runs a matrix through the QR decomposition and returns the transformed matrix and the forward and inverse transforming matrices \code{R, Rinv}.  If columns of the input matrix \code{X} are centered the QR transformed matrix will be orthogonal.  This is helpful in understanding the transformation and in scaling prior distributions on the transformed scale.  \code{not} can be specified to keep selected columns as-is.  \code{cornerQr} leaves the last column of \code{X} alone (possibly after centering).  When \code{not} is specified, the square transforming matrices have appropriate identity submatrices inserted so that recreation of original \code{X} is automatic.
}
\examples{
\dontrun{
  x <- 1 : 10
  X <- cbind(x, x^2)
  w <- selectedQr(X)
  w
  with(w, X \%*\% R)  # = scale(X, center=TRUE, scale=FALSE)
  Xqr <- w$X
  plot(X[, 1], Xqr[, 1])
  plot(X[, 1], Xqr[, 2])
  cov(X)
  cov(Xqr)
  X <- cbind(x, x^3, x^4, x^2)
  w <- selectedQr(X, not=2:3)
  with(w, X \%*\% R)
}
}
\author{
Ben Goodrich and Frank Harrell
}
