% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{infix}
\alias{infix}
\alias{\%>>\%}
\alias{\%v>\%}
\alias{\%*>\%}
\alias{\%>_\%}
\alias{\%>^\%}
\alias{\%^>\%}
\alias{\%|>\%}
\alias{\%||\%}
\alias{\%__\%}
\title{Infix operators}
\usage{
lhs \%>>\% rhs

lhs \%v>\% rhs

lhs \%*>\% rhs

lhs \%>_\% rhs

lhs \%>^\% rhs

lhs \%^>\% rhs

lhs \%|>\% rhs

lhs \%||\% rhs

lhs \%__\% rhs
}
\arguments{
\item{lhs}{left hand side value}

\item{rhs}{right hand side value}
}
\description{
Infix monadic sequence operators
}
\details{
See the main package help page (\code{?rmonad}) or the \code{intro} and
\code{cheatsheet} vignettes for more information.
}
\examples{
256 \%>>\% sqrt
256 \%v>\% sqrt
list(1,2,3) \%*>\% sum
iris \%>_\% plot \%>>\% summary 
1:10 \%>^\% rgamma(10, 5) \%>^\% rgamma(10, 6) \%^>\% cor
1:10 \%>>\% colSums \%|>\% sum
stop("die") \%||\% 4 \%>>\% sqrt
16 \%>>\% sqrt \%__\% 25 \%>>\% sqrt
}
