/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

import com.chenlb.mmseg4j.CharNode;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary {
    private static final Logger log = Logger.getLogger(Dictionary.class.getName());
    private File dicPath;
    private volatile Map<Character, CharNode> dict;
    private volatile Map<Character, Object> unit;
    private Map<File, Long> wordsLastTime = null;
    private long lastLoadTime = 0L;
    private static File defalutPath = null;
    private static final ConcurrentHashMap<File, Dictionary> dics = new ConcurrentHashMap();

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public static Dictionary getInstance() {
        File file = Dictionary.getDefalutPath();
        return Dictionary.getInstance(file);
    }

    public static Dictionary getInstance(String string) {
        return Dictionary.getInstance(new File(string));
    }

    public static Dictionary getInstance(File file) {
        Dictionary dictionary = dics.get(file);
        if (dictionary == null) {
            dictionary = new Dictionary(file);
            dics.put(file, dictionary);
        }
        return dictionary;
    }

    void destroy() {
        Dictionary.clear(this.dicPath);
        this.dicPath = null;
        this.dict = null;
        this.unit = null;
    }

    public static Dictionary clear(String string) {
        return Dictionary.clear(new File(string));
    }

    public static Dictionary clear(File file) {
        return dics.remove(file);
    }

    private Dictionary(File file) {
        this.init(file);
    }

    private void init(File file) {
        this.dicPath = file;
        this.wordsLastTime = new HashMap<File, Long>();
        this.reload();
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    protected File[] listWordsFiles() {
        return this.dicPath.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("words") && string.endsWith(".dic");
            }
        });
    }

    private Map<Character, CharNode> loadDic(File file) throws IOException {
        Object object;
        long l;
        InputStream inputStream = null;
        File file2 = new File(file, "chars.dic");
        if (file2.exists()) {
            inputStream = new FileInputStream(file2);
            this.addLastTime(file2);
        } else {
            inputStream = this.getClass().getResourceAsStream("/data/chars.dic");
            file2 = new File(this.getClass().getResource("/data/chars.dic").getFile());
        }
        final HashMap<Character, CharNode> hashMap = new HashMap<Character, CharNode>();
        int n = 0;
        long l2 = l = Dictionary.now();
        n = Dictionary.load(inputStream, new FileLoading(){

            public void row(String string, int n) {
                if (string.length() < 1) {
                    return;
                }
                String[] stringArray = string.split(" ");
                CharNode charNode = new CharNode();
                switch (stringArray.length) {
                    case 2: {
                        try {
                            charNode.setFreq((int)(Math.log(Integer.parseInt(stringArray[1])) * 100.0));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    case 1: {
                        hashMap.put(Character.valueOf(stringArray[0].charAt(0)), charNode);
                    }
                }
            }
        });
        log.info("chars loaded time=" + (Dictionary.now() - l) + "ms, line=" + n + ", on file=" + file2);
        InputStream inputStream2 = this.getClass().getResourceAsStream("/data/words.dic");
        if (inputStream2 != null) {
            object = new File(this.getClass().getResource("/data/words.dic").getFile());
            this.loadWord(inputStream2, hashMap, (File)object);
        }
        if ((object = this.listWordsFiles()) != null) {
            for (File file3 : object) {
                this.loadWord(new FileInputStream(file3), hashMap, file3);
                this.addLastTime(file3);
            }
        }
        log.info("load all dic use time=" + (Dictionary.now() - l2) + "ms");
        return hashMap;
    }

    private void loadWord(InputStream inputStream, Map<Character, CharNode> map, File file) throws IOException {
        long l = Dictionary.now();
        int n = Dictionary.load(inputStream, new WordsFileLoading(map));
        log.info("words loaded time=" + (Dictionary.now() - l) + "ms, line=" + n + ", on file=" + file);
    }

    private Map<Character, Object> loadUnit(File file) throws IOException {
        InputStream inputStream = null;
        File file2 = new File(file, "units.dic");
        if (file2.exists()) {
            inputStream = new FileInputStream(file2);
            this.addLastTime(file2);
        } else {
            inputStream = Dictionary.class.getResourceAsStream("/data/units.dic");
            file2 = new File(Dictionary.class.getResource("/data/units.dic").getFile());
        }
        final HashMap<Character, Object> hashMap = new HashMap<Character, Object>();
        long l = Dictionary.now();
        int n = Dictionary.load(inputStream, new FileLoading(){

            public void row(String string, int n) {
                if (string.length() != 1) {
                    return;
                }
                hashMap.put(Character.valueOf(string.charAt(0)), Dictionary.class);
            }
        });
        log.info("unit loaded time=" + (Dictionary.now() - l) + "ms, line=" + n + ", on file=" + file2);
        return hashMap;
    }

    public static int load(InputStream inputStream, FileLoading fileLoading) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), "UTF-8"));
        String string = null;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (string == null || string.startsWith("#")) continue;
            fileLoading.row(string, ++n);
        }
        return n;
    }

    private static char[] tail(String string) {
        char[] cArray = new char[string.length() - 1];
        string.getChars(1, string.length(), cArray, 0);
        return cArray;
    }

    private synchronized void addLastTime(File file) {
        if (file != null) {
            this.wordsLastTime.put(file, file.lastModified());
        }
    }

    public synchronized boolean wordsFileIsChange() {
        for (Map.Entry<File, Long> fileArray : this.wordsLastTime.entrySet()) {
            File file = fileArray.getKey();
            if (!file.canRead()) {
                return true;
            }
            if (file.lastModified() <= fileArray.getValue()) continue;
            return true;
        }
        File[] fileArray = this.listWordsFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (this.wordsLastTime.containsKey(file)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean reload() {
        HashMap<File, Long> hashMap = new HashMap<File, Long>(this.wordsLastTime);
        Map<Character, CharNode> map = this.dict;
        Map<Character, Object> map2 = this.unit;
        try {
            this.wordsLastTime.clear();
            this.dict = this.loadDic(this.dicPath);
            this.unit = this.loadUnit(this.dicPath);
            this.lastLoadTime = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            this.wordsLastTime.putAll(hashMap);
            this.dict = map;
            this.unit = map2;
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "reload dic error! dic=" + this.dicPath + ", and rollbacked.", iOException);
            }
            return false;
        }
        return true;
    }

    public boolean match(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        CharNode charNode = this.dict.get(Character.valueOf(string.charAt(0)));
        return this.search(charNode, string.toCharArray(), 0, string.length() - 1) >= 0;
    }

    public CharNode head(char c) {
        return this.dict.get(Character.valueOf(c));
    }

    public int search(CharNode charNode, char[] cArray, int n, int n2) {
        if (charNode != null) {
            return charNode.indexOf(cArray, n, n2);
        }
        return -1;
    }

    public int maxMatch(char[] cArray, int n) {
        CharNode charNode = this.dict.get(Character.valueOf(cArray[n]));
        return this.maxMatch(charNode, cArray, n);
    }

    public int maxMatch(CharNode charNode, char[] cArray, int n) {
        if (charNode != null) {
            return charNode.maxMatch(cArray, n + 1);
        }
        return 0;
    }

    public ArrayList<Integer> maxMatch(CharNode charNode, ArrayList<Integer> arrayList, char[] cArray, int n) {
        arrayList.clear();
        arrayList.add(0);
        if (charNode != null) {
            return charNode.maxMatch(arrayList, cArray, n + 1);
        }
        return arrayList;
    }

    public boolean isUnit(Character c) {
        return this.unit.containsKey(c);
    }

    public static File getDefalutPath() {
        if (defalutPath == null) {
            String string = System.getProperty("mmseg.dic.path");
            log.info("look up in mmseg.dic.path=" + string);
            if (string == null) {
                URL uRL = Dictionary.class.getClassLoader().getResource("data");
                if (uRL != null) {
                    string = uRL.getFile();
                    log.info("look up in classpath=" + string);
                } else {
                    string = System.getProperty("user.dir") + "/data";
                    log.info("look up in user.dir=" + string);
                }
            }
            if (!(defalutPath = new File(string)).exists()) {
                log.warning("defalut dic path=" + defalutPath + " not exist");
            }
        }
        return defalutPath;
    }

    public Map<Character, CharNode> getDict() {
        return this.dict;
    }

    public File getDicPath() {
        return this.dicPath;
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public static interface FileLoading {
        public void row(String var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WordsFileLoading
    implements FileLoading {
        final Map<Character, CharNode> dic;

        public WordsFileLoading(Map<Character, CharNode> map) {
            this.dic = map;
        }

        @Override
        public void row(String string, int n) {
            if (string.length() < 2) {
                return;
            }
            CharNode charNode = this.dic.get(Character.valueOf(string.charAt(0)));
            if (charNode == null) {
                charNode = new CharNode();
                this.dic.put(Character.valueOf(string.charAt(0)), charNode);
            }
            charNode.addWordTail(Dictionary.tail(string));
        }
    }
}

