% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateMDCEV.R
\name{SummaryWelfare}
\alias{SummaryWelfare}
\title{SummaryWelfare}
\usage{
SummaryWelfare(wtp, ci = 0.95)
}
\arguments{
\item{wtp}{list of welfare changes from SimulateWTP}

\item{ci}{confidence interval (for 95\% input 0.95)}
}
\value{
wtp_sum summary table of welfare results
}
\description{
Provide a summary of welfare changes for each policy
}
\examples{
\donttest{
data(data_rec, package = "rmdcev")
mdcev_est <- FitMDCEV(psi_formula = ~ 1,
data = subset(data_rec, id < 500),
model = "hybrid0",
algorithm = "MLE")

policies <- CreateBlankPolicies(npols = 2,
ngoods = mdcev_est[["stan_data"]][["J"]],
dat_psi = mdcev_est[["stan_data"]][["dat_psi"]],
price_change_only = TRUE)

df_sim <- PrepareSimulationData(mdcev_est, policies)

wtp <- SimulateMDCEV(df_sim$df_indiv, df_common = df_sim$df_common,
sim_options = df_sim$sim_options,
cond_err = 1, nerrs = 5, sim_type = "welfare")
SummaryWelfare(wtp)
}
}
