/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.attributesRI;

import dmLab.array.functions.DiscFunctions;
import dmLab.utils.list.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public final class Ranking {
    private String[] names;
    private float[] weights;
    private String measureName;
    private HashMap<String, Integer> map;
    private boolean normalize = false;

    public Ranking() {
    }

    /*
     * WARNING - void declaration
     */
    public Ranking(int number) {
        void var1_1;
        this.init((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void init(int number) {
        void var1_1;
        this.names = new String[number];
        this.weights = new float[var1_1];
        this.map = new HashMap();
    }

    public final int size() {
        return this.weights.length;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean put(String name, float weight, int position) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (position < 0 || position >= this.names.length) {
            return false;
        }
        this.names[position] = name;
        this.weights[position] = var2_2;
        this.map.put((String)var1_1, (int)var3_3);
        return true;
    }

    public final String[] getAttributesNames() {
        return this.names;
    }

    /*
     * WARNING - void declaration
     */
    public final float compare(Ranking ranking) {
        void var2_4;
        Ranking ranking2 = ranking;
        Ranking ranking3 = ranking2;
        ranking3 = this;
        if (ranking2.weights.length != ranking3.weights.length) {
            return -1.0f;
        }
        float distance = 0.0f;
        ranking3 = this;
        int size = ranking3.weights.length;
        float factor = size;
        int i = 0;
        while (i < size) {
            String string = this.names[i];
            Object object = ranking;
            object = ((Ranking)object).map.get(string);
            int position = object != null ? (Integer)object : -1;
            if (position == -1) {
                position = size;
            }
            distance += (float)Math.abs(i - position) / factor;
            ++i;
        }
        return (float)var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public final float commonPart(Ranking ranking) {
        void var2_2;
        void var3_3;
        int size = this.names.length;
        int common = 0;
        int i = 0;
        while (i < size) {
            if (ranking.contains(this.names[i])) {
                ++common;
            }
            ++i;
        }
        return (float)var3_3 / (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(String name) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setMeasureName(String measureName) {
        void var1_1;
        this.measureName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer buf = new StringBuffer();
        Ranking ranking = this;
        int size = ranking.weights.length;
        buf.append("position,attribute,").append(this.measureName).append('\n');
        int i = 0;
        while (i < size) {
            buf.append(i + 1).append(',');
            buf.append(this.names[i]).append(',');
            buf.append(this.weights[i]);
            buf.append('\n');
            ++i;
        }
        return var1_1.toString();
    }

    public final boolean load(String fileName) {
        BufferedReader fileReader;
        File file = new File(fileName);
        if (!file.exists()) {
            return false;
        }
        try {
            fileReader = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException iOException) {
            System.err.println("Error opening file. File: ".concat(String.valueOf(fileName)));
            return false;
        }
        StringList lines = new StringList();
        String line = null;
        do {
            try {
                line = fileReader.readLine();
            }
            catch (Exception e) {
                System.out.println("Error reading input file.");
                e.printStackTrace();
            }
            if (line == null || line.length() == 0) continue;
            lines.add(line);
        } while (line != null);
        this.init(lines.size() - 1);
        char[] separators = new char[]{','};
        int size = lines.size();
        int i = 0;
        while (i < size) {
            String[] lineList = DiscFunctions.tokenizeString(lines.get(i), separators, false);
            if (i == 0) {
                this.measureName = lineList[2];
            } else {
                this.put(lineList[1], Float.parseFloat(lineList[2]), i - 1);
            }
            ++i;
        }
        try {
            ((BufferedReader)((Object)file)).close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing input file.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final float getWeight(int index) {
        void var1_1;
        return this.weights[var1_1];
    }
}

