/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.SplitCriterion;

public abstract class EntropyBasedSplitCrit
extends SplitCriterion {
    private static final long serialVersionUID = -2618691439791653056L;
    protected static double log2 = Math.log(2.0);

    public final double logFunc(double num) {
        if (num < 1.0E-6) {
            return 0.0;
        }
        return num * Math.log(num) / log2;
    }

    public final double oldEnt(Distribution bags) {
        double returnValue = 0.0;
        int j = 0;
        while (j < bags.numClasses()) {
            returnValue += this.logFunc(bags.perClass(j));
            ++j;
        }
        return this.logFunc(bags.total()) - returnValue;
    }

    public final double newEnt(Distribution bags) {
        double returnValue = 0.0;
        int i = 0;
        while (i < bags.numBags()) {
            int j = 0;
            while (j < bags.numClasses()) {
                returnValue += this.logFunc(bags.perClassPerBag(i, j));
                ++j;
            }
            returnValue -= this.logFunc(bags.perBag(i));
            ++i;
        }
        return -returnValue;
    }

    public final double splitEnt(Distribution bags) {
        double returnValue = 0.0;
        int i = 0;
        while (i < bags.numBags()) {
            returnValue += this.logFunc(bags.perBag(i));
            ++i;
        }
        return this.logFunc(bags.total()) - returnValue;
    }
}

