/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.pmml.Function;

public class BuiltInArithmetic
extends Function {
    private static final long serialVersionUID = 2275009453597279459L;
    protected Operator m_operator = Operator.ADDITION;

    public BuiltInArithmetic(Operator op) {
        this.m_operator = op;
        this.m_functionName = this.m_operator.toString();
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> paramDefs) throws Exception {
        this.m_parameterDefs = paramDefs;
        if (this.m_parameterDefs.size() != 2) {
            throw new Exception("[Arithmetic] wrong number of parameters. Recieved " + this.m_parameterDefs.size() + ", expected 2.");
        }
    }

    @Override
    public String[] getParameterNames() {
        String[] result = new String[]{"A", "B"};
        return result;
    }

    @Override
    public Attribute getOutputDef() {
        return new Attribute("BuiltInArithmeticResult:" + this.m_operator.toString());
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        if (this.m_parameterDefs == null) {
            throw new Exception("[BuiltInArithmetic] incoming parameter structure has not been set!");
        }
        if (this.m_parameterDefs.size() != 2 || incoming.length != 2) {
            throw new Exception("[BuiltInArithmetic] wrong number of parameters!");
        }
        double result = this.m_operator.eval(incoming[0], incoming[1]);
        return result;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String pad) {
        return String.valueOf(pad) + ((Attribute)this.m_parameterDefs.get(0)).name() + this.m_functionName + ((Attribute)this.m_parameterDefs.get(1)).name();
    }

    static enum Operator {
        ADDITION(" + "){

            @Override
            double eval(double a, double b) {
                return a + b;
            }
        }
        ,
        SUBTRACTION(" - "){

            @Override
            double eval(double a, double b) {
                return a - b;
            }
        }
        ,
        MULTIPLICATION(" * "){

            @Override
            double eval(double a, double b) {
                return a * b;
            }
        }
        ,
        DIVISION(" / "){

            @Override
            double eval(double a, double b) {
                return a / b;
            }
        };

        private final String m_stringVal;

        abstract double eval(double var1, double var3);

        private Operator(String opName) {
            this.m_stringVal = opName;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

